
#include "Datawhitening.h"

static uint8_t WhiteningKeyMSB = 0x01;                                          // Global variables so the value is kept after starting the de-whitening process
static uint8_t WhiteningKeyLSB = 0xFF;                                                  

/*******************************************************************************
*buffer is a char pointer indicating the data to be whiten / de-whiten
* buffersize is the number of char to be whiten / de-whiten
* >> The whitened / de-whitened data are directly placed into the pointer
*******************************************************************************/

void RadioComputeWhitening( uint8_t *buffer, uint16_t bufferSize )              //IBM Whitening
{
  uint8_t i = 0;
  uint16_t j = 0;
  uint8_t WhiteningKeyMSBPrevious = 0;                                          // 9th bit of the LFSR
                                                    
  
  for( j = 0; j < bufferSize; j++ )                                             // byte counter
  {   
      buffer[j] ^= WhiteningKeyLSB;                                             // XOR between the data and the whitening key
      for( i = 0; i < 8; i++ )                                                  // 8-bit shift between each byte
      {
          WhiteningKeyMSBPrevious = WhiteningKeyMSB;
          WhiteningKeyMSB = ( WhiteningKeyLSB & 0x01 ) ^ ( ( WhiteningKeyLSB >> 5 ) & 0x01 );
          WhiteningKeyLSB= ( ( WhiteningKeyLSB >> 1 ) & 0xFF ) | ( ( WhiteningKeyMSBPrevious << 7 ) & 0x80 );
      }
  }
}

void RadioComputeWhitening_CCIT( uint8_t *buffer, uint16_t bufferSize )         //CCIT Whitening
{
uint8_t i = 0;
uint16_t j = 0;
uint8_t WhiteningKeyMSBPrevious = 0;
uint8_t revertedWhiteningKeyLSB = 0;
revertedWhiteningKeyLSB = WhiteningKeyLSB;                                      // WhiteningKeyLSB is 0xFF at init
  for( j = 0; j < bufferSize - 1; j++ )
  {
    buffer[j] ^= revertedWhiteningKeyLSB;
    for( i = 0; i < 8; i++ )
    {
      WhiteningKeyMSBPrevious = WhiteningKeyMSB;
      WhiteningKeyMSB = ( WhiteningKeyLSB & 0x01 ) ^ ( ( WhiteningKeyLSB >> 5 ) & 0x01 );
      WhiteningKeyLSB = ( ( ( WhiteningKeyMSBPrevious << 7 ) & 0x80 | ( WhiteningKeyLSB >> 1 ) & 0xFF ) );
    }
    revertedWhiteningKeyLSB = (WhiteningKeyLSB & 0xF0) >> 4 | (WhiteningKeyLSB & 0x0F) << 4;
    revertedWhiteningKeyLSB = (revertedWhiteningKeyLSB & 0xCC) >> 2 | (revertedWhiteningKeyLSB & 0x33) << 2;
    revertedWhiteningKeyLSB = (revertedWhiteningKeyLSB & 0xAA) >> 1 | (revertedWhiteningKeyLSB & 0x55) << 1;
  }
}